/****************************************************************/
/* BGP-4 Protocol Viewer                                        */
/*    Programmed By K.Kondo IIJ 1999/08                         */
/*                                                              */
/* Utility functions                                            */
/****************************************************************/
/* utils.c,v 1.9 2002/04/09 09:43:06 kuniaki Exp */

/*
 * Copyright (c) 1998-2000 Internet Initiative Japan Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution with functional modification must include
 *    prominent notice stating how and when and by whom it is
 *    modified.
 * 3. Redistributions in binary form have to be along with the source
 *    code or documentation which include above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 4. All commercial advertising materials mentioning features or use
 *    of this software must display the following acknowledgement:
 *      This product includes software developed by Internet
 *      Initiative Japan Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.
 */

#include "utils.h"

/*
 * converters between digits and figures
 */
u_short buf2ushort(u_char *ptr)
{
	return (u_short)((*ptr<<8)| *(ptr+1));
}

u_long buf2ulong(u_char *ptr)
{
	return (u_long)((*(ptr)<<24) | (*(ptr+1)<<16) |
			(*(ptr+2)<<8)| *(ptr+3));
}

void store_int16(ptr, var)
u_char *ptr;
u_short var;
{
	*ptr     = (var>>8) & 0xff;
	*(ptr+1) =  var     & 0xff;
}

void store_int32(u_char *ptr, u_long var)
{
	*(ptr)   = (var>>24) & 0xff;
	*(ptr+1) = (var>>16) & 0xff;
	*(ptr+2) = (var>>8 ) & 0xff;
	*(ptr+3) =  var      & 0xff;
}

boolean chkfmt(int type, char *str)
{
	int	cnt1, cnt2;
	boolean	ret;
	char	cstr[16];

	switch(type) {
	case CHKFMT_ADR:
		strcpy(cstr, ADR_CSET);
		break;
	case CHKFMT_PRF:
		strcpy(cstr, PRF_CSET);
		break;
	case CHKFMT_INT:
		strcpy(cstr, INT_CSET);
		break;
	default:
		ret = false;
	}

#ifdef DEBUG
	printf("DEBUG: CHKFMT: Type = %d, String = '%s'\n",
		type, str);
#endif

	if (ret == false) return(ret);

	ret = true;
	cnt1 = 0;
	while(1) {
		if (*(str+cnt1) == '\0') break;
		cnt2 = 0;
		while(1) {
			if (*(cstr+cnt2) == '\0') break;
			if (*(str+cnt1) == *(cstr+cnt2)) break;
			cnt2++;
		}
		if (strlen(cstr) <= cnt2) {
			ret = false;
			break;
		}
		cnt1++;
	}
	return(ret);
}

int checkpw(char *encripted_strings, char *pass)
{

        char    salt[9];
        char    encoded[128];

	bzero(salt, 9);
	bzero(encoded, 128);

	strncpy(salt, encripted_strings, 2);

        strcpy(&encoded[0], (char *)crypt(pass, salt));

#ifdef DEBUG
        printf("DEBUG: CHACKPW: Phrase : %s\n",encripted_strings);
        printf("DEBUG: CHACKPW: Encoded: %s\n",encoded);
#endif

        if(strncmp(encripted_strings, encoded,sizeof(salt)) == 0) {
#ifdef DEBUG
                printf("DEBUG: CHACKPW: Password OK!\n");
#endif
                return(1);
        } else {
#ifdef DEBUG
                printf("DEBUG: CHACKPW: Password Mismatch!\n");
#endif
                return(0);
        }
}

void wait_sigchld()
{
	while( waitpid(-1,NULL,WNOHANG) > 0 );
}

int bintostrv6(char *ptr, char *str)
{
        int     cnt;
        int     mzerop;
        int     mzero;
        int     mf;
        int     zc;
        short   wrd[8];
        char    sbuf[6];

        cnt = 0;
        mzerop = -1;
        mzero = 0;
        mf = 0;
        zc = 0;
        while(cnt < 8) {
                wrd[cnt] = ntohs(*(short *)(ptr+(cnt*2)));

                if (wrd[cnt] == 0) {
                        if (mf == 0) {
                                mf = 1;
                                zc = 1;
                        } else {
                                zc++;
                        }
                } else {
                        if (mf == 1) {
                                mf = 0;
                                if (mzero < zc) {
                                        mzero = zc;
                                        mzerop = cnt-zc;
                                }
                        }
                }
                cnt++;
        }
        if (mf == 1) {
                if (mzero < zc) {
                        mzero = zc;
                        mzerop = cnt-zc;
                }
        }

        strcpy(str, "");
        cnt = 0;
        while(cnt < 8) {
                if (mzerop == cnt) {
                        strcat(str, "::");
                        cnt+=mzero;
                        continue;
                }
                if (cnt != 0) {
                        if (str[strlen(str)-1] != ':') {
                                strcat(str, ":");
                        }
                }
                sprintf(sbuf, "%X", wrd[cnt]);
                if (strlen(sbuf) > 4) {
                        strcat(str, &sbuf[4]);
                } else {
                        strcat(str, sbuf);
                }
                cnt++;
        }
        return(strlen(str));
}

char *strtobinv6(char *ptr, char *str)
{
        short   wrd[7], wrd1[7];
        char    adrbuf[40];
        char    strbuf[5];
        char    cnt,c2,c3;
        char    *cptr;
        char    fstr[40],estr[40];

        bzero(wrd, 16);
        strcpy(adrbuf, str);

        cptr = strstr(adrbuf, "::");
        if (cptr != NULL) {
                bzero(fstr, 40);
                strncpy(fstr, &adrbuf[0], (cptr - adrbuf));
                strcpy(estr, cptr+2);
        } else {
                strcpy(fstr, adrbuf);
                strcpy(estr, "");
        }

        cnt = 0;
        c2 = 0;
        c3 = 0;
        bzero(strbuf, 6);
        while(fstr[cnt] != '\0') {
                if (fstr[cnt] == ':') {
                        c2 = 0;
                        sscanf(strbuf, "%X", &wrd[c3]);
                        bzero(strbuf, 6);
                        c3++;
                } else {
                        strbuf[c2] = fstr[cnt];
                        c2++;
                }
                cnt++;
        }
        if (cnt != 0) {
                sscanf(strbuf, "%X", &wrd[c3]);
        }

        cnt = 0;
        c2 = 0;
        c3 = 0;
        bzero(strbuf, 6);
        while(estr[cnt] != '\0') {
                if (estr[cnt] == ':') {
                        c2 = 0;
                        sscanf(strbuf, "%X", &wrd1[c3]);
                        bzero(strbuf, 6);
                        c3++;
                } else {
                        strbuf[c2] = estr[cnt];
                        c2++;
                }
                cnt++;
        }
        if (cnt != 0) {
                sscanf(strbuf, "%X", &wrd1[c3]);
                c3++;
        }

        c2 = 7;
        while(c3 > 0){
                wrd[c2] = wrd1[c3-1];
                c3--;
                c2--;
        }

        cnt = 0;
        while(cnt < 8) {
                *((short *)(ptr + (cnt*2))) = htons(wrd[cnt]);
                cnt++;
        }

        return(ptr);
}

void store_v6addr(char *dest, char *src)
{
	memcpy(dest, src, IPV6_ADDR_LEN);
}
