/****************************************************************/
/* BGP-4 Protocol Viewer                                        */
/*    Programmed By K.Kondo IIJ 2002/03                         */
/*                                                              */
/* Multi Protocol Extentions                                    */
/****************************************************************/
/* mpnlri.c,v 1.5 2002/04/01 10:01:34 kuniaki Exp */

/*
 * Copyright (c) 2002 Internet Initiative Japan Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution with functional modification must include
 *    prominent notice stating how and when and by whom it is
 *    modified.
 * 3. Redistributions in binary form have to be along with the source
 *    code or documentation which include above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 4. All commercial advertising materials mentioning features or use
 *    of this software must display the following acknowledgement:
 *      This product includes software developed by Internet
 *      Initiative Japan Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.
 */

#include "mpnlri.h"

int pr_mp_reach_nlri(char *ptr, int len, int pn)
{
	char	pline[LOGSTRSIZE];
	char	sbuf[LOGSTRSIZE];
	char 	*cptr;
	short	afi;
	char	safi;
	char	nexthop_len;
	char	*nexthop;
	char	nofsnpa;
	char	snpalen;
	char	*snpa;
	int	cnt,cnt2;
	char	c2;
	u_char	c;
	u_char	nlrilen;
	char	nlri[16];
	int	pcnt;

	static char	binc[] = {"0123456789ABCDEF"};

#ifdef DEBUG
	printf("DEBUG: MPNLRI_REACH: Receive MP_BGP Capability Attributes\n");
#endif

	cptr = ptr;
	afi = ntohs(*(short *)cptr);
	cptr+=2;
	safi = *cptr;
	cptr++;

#ifdef DEBUG
	printf("DEBUG: MPNLRI_REACH: AFI = %d, SAFI=%d\n", afi, safi);
#endif

	switch(afi) {
#ifdef HAVE_IPv6
	case AF_IPV6:
		break;
#endif
	default:
		/* non-support AFI */
		pr_log(VLOG_UPAT, pn, "    Unsupported AFI - Ignored\n", OFF);
		return(1);
	}

	switch(safi) {
	case SAFI_NLRI_UNI:
		break;
	default:
		/* non-support SAFI */
		pr_log(VLOG_UPAT, pn, "    Unsupported SAFI - Ignored\n", OFF);
		return(1);
	}
	sprintf(pline, "    Receive MP: AFI: %d SAFI: %d\n", afi, safi);
	pr_log(VLOG_UPAT, pn, pline, OFF);

	/* Next Hop Field */
	nexthop_len = *cptr;
	sprintf(pline, "    MPext: Next Hop Length = %d\n", nexthop_len);
	pr_log(VLOG_UPAT, pn, pline, OFF);
	nexthop = (char *)malloc(nexthop_len);
	memcpy(nexthop, cptr+1, nexthop_len);
	bintostrv6(nexthop, sbuf);
	sprintf(pline, "    MPext: Next Hop : %s\n", sbuf);
	pr_log(VLOG_UPAT, pn, pline, OFF);
	free(nexthop);
	cptr += (nexthop_len + 1);

	/* SNPAs */
	nofsnpa = *cptr;
	sprintf(pline, "    MPext: Number of SNPAs = %d\n", nofsnpa);
	pr_log(VLOG_UPAT, pn, pline, OFF);
	cptr++;
	cnt = 0;
	while(cnt < nofsnpa) {
		snpalen = *cptr;
		c = snpalen % 2;
		c += (int)(snpalen/2);
		snpa = (char *)malloc(c);
		memcpy(snpa, cptr+1, c);
		cnt2 = 0;
		bzero(sbuf, LOGSTRSIZE);
		while(cnt2 < snpalen) {
			c = *(snpa+((int)(cnt/2)));
			if ((cnt2%2) == 0) {
				c &= 0xF0;
				c >>= 4;
				sbuf[cnt2] = binc[c];
			} else {
				c &= 0x0F;
				sbuf[cnt2] = binc[c];
			}
			cnt2++;
		}
		sprintf(pline, "    MPext: SNPA[%d]: %s\n", cnt, sbuf);
		pr_log(VLOG_UPAT, pn, pline, OFF);
		free(snpa);
		cptr += c;
		cnt++;
	}

	/* NLRI */
	cnt = len - (cptr - ptr);
	cnt2 = 0;
	pcnt = 0;
	while(cnt2 < cnt) {
		bzero(nlri, 16);
		nlrilen = *cptr;
		pcnt++;
		if (nlrilen != 0) {
			c = nlrilen % 8;
			if (c == 0) {
				memcpy(nlri, cptr+1, (int)(nlrilen/8));
				cptr += (int)(nlrilen/8)+1;
				cnt2 += (int)(nlrilen/8)+1;
			} else {
				memcpy(nlri, cptr+1, (int)(nlrilen/8)+1);
				cptr += (int)(nlrilen/8)+2;
				cnt2 += (int)(nlrilen/8)+2;
				c2 = 0x80;
				c2 >>= c;
				nlri[(int)(nlrilen/8)] &= c2;
			}
		} else {
			cptr++;
			cnt2++;
		}
		bintostrv6(nlri, sbuf);
		sprintf(pline, "    MPext: Prefix : %s/%d\n", sbuf, nlrilen);
		pr_log(VLOG_UPAT, pn, pline, OFF);
	}
	return(pcnt);
}

int pr_mp_unreach_nlri(char *ptr, int len, int pn)
{
	char	pline[LOGSTRSIZE];
	char	sbuf[LOGSTRSIZE];
	char 	*cptr;
	short	afi;
	char	safi;
	int	cnt,cnt2;
	char	c2;
	u_char	c;
	u_char	nlrilen;
	char	nlri[16];
	int	pcnt;

#ifdef DEBUG
	printf("DEBUG: MPNLRI_UNREACH: Receive MP_BGP Capability Attributes\n");
#endif

	cptr = ptr;
	afi = ntohs(*(short *)cptr);
	cptr+=2;
	safi = *cptr;
	cptr++;

#ifdef DEBUG
	printf("DEBUG: MPNLRI_UNREACH: AFI = %d, SAFI=%d\n", afi, safi);
#endif

	switch(afi) {
#ifdef HAVE_IPv6
	case AF_IPV6:
		break;
#endif
	default:
		/* non-support AFI */
		pr_log(VLOG_UPAT, pn, "    Unsupported AFI - Ignored\n", OFF);
		return(1);
	}

	switch(safi) {
	case SAFI_NLRI_UNI:
		break;
	default:
		/* non-support SAFI */
		pr_log(VLOG_UPAT, pn, "    Unsupported SAFI - Ignored\n", OFF);
		return(1);
	}
	sprintf(pline, "    Receive MP: UNREACH: AFI: %d SAFI: %d\n", afi, safi);
	pr_log(VLOG_UPAT, pn, pline, OFF);

	/* NLRI */
	cnt = len - (cptr - ptr);
	cnt2 = 0;
	pcnt = 0;
	while(cnt2 < cnt) {
		bzero(nlri, 16);
		nlrilen = *cptr;
		pcnt++;
		if (nlrilen != 0) {
			c = nlrilen % 8;
			if (c == 0) {
				memcpy(nlri, cptr+1, (int)(nlrilen/8));
				cptr += (int)(nlrilen/8)+1;
				cnt2 += (int)(nlrilen/8)+1;
			} else {
				memcpy(nlri, cptr+1, (int)(nlrilen/8)+1);
				cptr += (int)(nlrilen/8)+2;
				cnt2 += (int)(nlrilen/8)+2;
				c2 = 0x80;
				c2 >>= c;
				nlri[(int)(nlrilen/8)] &= c2;
			}
		} else {
			cptr++;
			cnt2++;
		}
		bintostrv6(nlri, sbuf);
		sprintf(pline, "    MPext: Withdrawn : %s/%d\n", sbuf, nlrilen);
		pr_log(VLOG_UPAT, pn, pline, OFF);
	}
	return(pcnt);
}

