/****************************************************************/
/* BGP-4 Protocol Viewer                                        */
/*    Programmed By K.Kondo IIJ 2000/8                          */
/*                                                              */
/* Utility Sub-routines                                         */
/****************************************************************/
/* utils.h,v 1.4 2001/10/01 11:12:33 kuniaki Exp */

/*
 * Copyright (c) 1998-2000 Internet Initiative Japan Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution with functional modification must include
 *    prominent notice stating how and when and by whom it is
 *    modified.
 * 3. Redistributions in binary form have to be along with the source
 *    code or documentation which include above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 4. All commercial advertising materials mentioning features or use
 *    of this software must display the following acknowledgement:
 *      This product includes software developed by Internet
 *      Initiative Japan Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.
 */

#ifndef _UTILS_H
#define _UTILS_H

#include <sys/param.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <unistd.h>



#define OFF                     0
#define ON                      1

typedef char                    boolean;
#define true                    1
#define false                   0

#define CHKFMT_ADR	1
#define CHKFMT_PRF	2
#define CHKFMT_INT	3

#define ADR_CSET	"0123456789."
#define PRF_CSET	"0123456789./"
#define INT_CSET	"0123456789"

/* Functions */
extern u_short 	buf2ushort(/*ptr*/);
extern u_long 	buf2ulong(/*ptr*/);
extern void 	store_int16(/*ptr, var*/);
extern void 	store_int32(/*ptr, var*/);
extern boolean	chkfmt(/* int type, char *str */);
extern int	checkpw(/* char *phrase, char *pass */);
extern void 	wait_sigchld();

#endif /* _UTILS_H */
