/****************************************************************/
/* BGP-4 Protocol Viewer                                        */
/*    Programmed By K.Kondo IIJ 1999/08                         */
/*                                                              */
/* Utility functions                                            */
/****************************************************************/
/* utils.c,v 1.7 2001/11/13 06:21:28 kuniaki Exp */

/*
 * Copyright (c) 1998-2000 Internet Initiative Japan Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution with functional modification must include
 *    prominent notice stating how and when and by whom it is
 *    modified.
 * 3. Redistributions in binary form have to be along with the source
 *    code or documentation which include above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 4. All commercial advertising materials mentioning features or use
 *    of this software must display the following acknowledgement:
 *      This product includes software developed by Internet
 *      Initiative Japan Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.
 */

#include "utils.h"

/*
 * converters between digits and figures
 */
u_short buf2ushort(u_char *ptr)
{
	return (u_short)((*ptr<<8)| *(ptr+1));
}

u_long buf2ulong(u_char *ptr)
{
	return (u_long)((*(ptr)<<24) | (*(ptr+1)<<16) |
			(*(ptr+2)<<8)| *(ptr+3));
}

void store_int16(ptr, var)
u_char *ptr;
u_short var;
{
	*ptr     = (var>>8) & 0xff;
	*(ptr+1) =  var     & 0xff;
}

void store_int32(u_char *ptr, u_long var)
{
	*(ptr)   = (var>>24) & 0xff;
	*(ptr+1) = (var>>16) & 0xff;
	*(ptr+2) = (var>>8 ) & 0xff;
	*(ptr+3) =  var      & 0xff;
}

boolean chkfmt(int type, char *str)
{
	int	cnt1, cnt2;
	boolean	ret;
	char	cstr[16];

	switch(type) {
	case CHKFMT_ADR:
		strcpy(cstr, ADR_CSET);
		break;
	case CHKFMT_PRF:
		strcpy(cstr, PRF_CSET);
		break;
	case CHKFMT_INT:
		strcpy(cstr, INT_CSET);
		break;
	default:
		ret = false;
	}

#ifdef DEBUG
	printf("DEBUG: CHKFMT: Type = %d, String = '%s'\n",
		type, str);
#endif

	if (ret == false) return(ret);

	ret = true;
	cnt1 = 0;
	while(1) {
		if (*(str+cnt1) == '\0') break;
		cnt2 = 0;
		while(1) {
			if (*(cstr+cnt2) == '\0') break;
			if (*(str+cnt1) == *(cstr+cnt2)) break;
			cnt2++;
		}
		if (strlen(cstr) <= cnt2) {
			ret = false;
			break;
		}
		cnt1++;
	}
	return(ret);
}

int checkpw(char *encripted_strings, char *pass)
{

        char    salt[9];
        char    encoded[128];

	bzero(salt, 9);
	bzero(encoded, 128);

	strncpy(salt, encripted_strings, 2);

        strcpy(&encoded[0], (char *)crypt(pass, salt));

#ifdef DEBUG
        printf("DEBUG: CHACKPW: Phrase : %s\n",encripted_strings);
        printf("DEBUG: CHACKPW: Encoded: %s\n",encoded);
#endif

        if(strncmp(encripted_strings, encoded,sizeof(salt)) == 0) {
#ifdef DEBUG
                printf("DEBUG: CHACKPW: Password OK!\n");
#endif
                return(1);
        } else {
#ifdef DEBUG
                printf("DEBUG: CHACKPW: Password Mismatch!\n");
#endif
                return(0);
        }
}

void wait_sigchld()
{
	while( waitpid(-1,NULL,WNOHANG) > 0 );
}

