/****************************************************************/
/* BGP-4 Protocol Viewer					*/
/*    Programmed By K.Kondo IIJ	1997/12				*/
/*								*/
/* Some Define and Structs					*/
/****************************************************************/
/* bgp.h,v 1.32 2001/09/05 11:14:54 kuniaki Exp */

/*
 * Copyright (c) 1998-2001 Internet Initiative Japan Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution with functional modification must include
 *    prominent notice stating how and when and by whom it is
 *    modified.
 * 3. Redistributions in binary form have to be along with the source
 *    code or documentation which include above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 4. All commercial advertising materials mentioning features or use
 *    of this software must display the following acknowledgement:
 *      This product includes software developed by Internet
 *      Initiative Japan Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.
 */

#ifndef _BGP_H
#define _BGP_H

#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "utils.h"

#define BV_VERSION	"0.29Alpha"
#define BV_COPYRIGHT	"Copyright (c) 1998-2001 Internet Initiative Japan Inc."

/* BGP Header Type field defines */
#define BGPTYPES                5
#define BGP_UNDEFINE            0
#define BGP_OPEN                1
#define BGP_UPDATE              2
#define BGP_NOTIFICATION        3
#define BGP_KEEPALIVE           4

/* BGP States */
#define IDLE                    1
#define CONNECT                 2
#define ACTIVE                  3
#define OPENSENT                4
#define OPENCONFIRM             5
#define ESTABLISHED             6

/* BGP Events */
#define BGP_NONE                0
#define BGP_START               1
#define BGP_STOP                2
#define BGP_TRANS_CNT_OPEN      3
#define BGP_TRANS_CNT_CLOSE     4
#define BGP_TRANS_CNT_OPEN_FAIL 5
#define BGP_TRANS_FATAL_ERR     6
#define CNT_RETRY_TIME_EXP      7
#define HOLD_TIME_EXP           8
#define KEEPALIVE_TIME_EXP      9
#define RECV_OPEN               10
#define RECV_KEEPALIVE          11
#define RECV_UPDATE             12
#define RECV_NOTIFICATION       13

/* Timer Default Value */
#define CNT_RETRY_TIMER		120
#define HOLD_TIMER		90
#define KEEPALIVE_TIMER		30
#define MINORIGIN_INTEVAL	15
#define MINROUTEADV_INTERVAL	30
#define RE_INITIAL_TIMER	60
#ifdef RTHISTORY
#define DEFAULT_CLEARHISTORY	86400 /* Second = 24Hour */
#endif

/* TIMER IDs */
#define ID_CNT_RETRY_TIMER	1
#define ID_HOLD_TIMER		2
#define ID_KEEPALIVE_TIMER	3
#define ID_MINORIGIN_INTERVAL	4
#define ID_MINROUTEADV_INTERVAL	5
#define ID_RE_INITIAL_TIMER	6

#define ID_BGPINFO_TIMER	10

/* Socket Status */
#define SOCK_ACCEPTING		1
#define SOCK_CONNECTED		2

/* Err Codes */
#define MESSAGE_HEADER_ERROR		1
#define OPEN_MESSAGE_ERROR		2
#define UPDATE_MESSAGE_ERROR		3
#define HOLD_TIME_EXPIERD		4
#define FINITE_STATE_MACHINE_ERROR	5
#define CEASE				6

#define CONNECTION_NOT_SYNCRONIZED	1
#define BAD_MESSAGE_LENGTH		2
#define BAD_MESSAGE_TYPE		3

#define UNSUPPORTED_VERSION_NUMBER	1
#define BAD_PEER_AS			2
#define BAD_BGP_IDENTIFIER		3
#define UNSUPPORTED_OPTIONAL_PARAMETER	4
#define AUTHENTICATION_FAILURE		5
#define UNACCEPTABLE_HOLD_TIME		6

#define MALFORMED_ATTRIBUTE_LIST	1
#define UNRECOGNIZED_WELL_KNOWN_ATTRIBUTE	2
#define MISSING_WELL_KNOWN_ATTRIBUTE	3
#define ATTRIBUTE_FLAGS_ERROR		4
#define ATTRIBUTE_LENGTH_ERROR		5
#define INVALID_ORIGIN_ATTRIBUTE	6
#define AS_ROUTING_LOOP			7
#define INVALID_NEXT_HOP_ATTRIBUTE	8
#define OPTIONAL_ATTRIBUTE_ERROR	9
#define INVALID_NETWORK_FIELD		10
#define MALFORMED_AS_PATH		11

/* PATH ATTRIBUTE Type Code */
#define ATTR_MAX			10
#define ATTR_UNKNOWN			0
#define ATTR_ORIGIN			1
#define ATTR_AS_PATH			2
#define ATTR_NEXT_HOP			3
#define ATTR_MULTI_EXIT_DISC		4
#define ATTR_LOCAL_PREF			5
#define ATTR_ATOMIC_AGGREGATE		6
#define ATTR_AGGREGATOR			7
#define ATTR_COMMUNITIES		8
#define ATTR_ORIGINATOR_ID		9
#define ATTR_CLUSTER_LIST		10

/* Default BGP port */
#define BGP_PORT		179
#define BGP_MAX_PACKET_SIZE	4096

#define MAXPEERS		128
#define HEADERLENGTH		19
#define MARKERLENGTH		16
#define CONF_FILE		"/usr/local/etc/bgpview.cfg"
#define SPOOL_DEFAULT		"/tmp"
#ifdef FILENAME_MAX
#define	FNAMESIZE		FILENAME_MAX
#else
#define FNAMESIZE		1024
#endif

/* finish command parameter */
#define PROC_SHUTDOWN		1
#define PROC_REBOOT		2
#define PROC_CHILDEND		3

typedef u_long	net_ulong;	/* network-byte-ordered u_long */

extern	net_ulong	IDENT;
extern  u_short		LOCAL_AS;
extern	struct timeval	uptime;

typedef struct {
        u_short length;
        u_char  type;
} BGPV4_HEADER;

typedef struct {
	net_ulong	neighbor;		/* Neighbor Address */
	u_short		remote_as;		/* REMOTE AS */
	net_ulong	local_id;		/* local IDENT */
	u_short		local_as;		/* local AS */
	int		soc;			/* Socket Discripter */
	int		flag;			/* Socket Flags	*/
	int		status;			/* BGP Status (FSM) */
	int		event;			/* BGP Event (FSM) */
	int		resume;			/* RESUME FLAG */
	int		datalen;		/* Recv Data Length */
	char		*data;			/* Recv Data */
	int		holdtimer;		/* Hold Timer Value */
	int		keepalive;		/* Keepalive Timer Value */
	char		logname[FNAMESIZE];	/* Log File Name */
	u_char		logtype;		/* Logging Type */
	boolean		status_notify;		/* statys notify flag */
	FILE		*logfd;			/* Log File Filedescripter */
	char		prefixout[FNAMESIZE];	/* Prefix Log File Name */
	boolean		prefixsum;		/* Add prefix sum to Prefix log */
	FILE		*pfd;			/* Prefix Log File Descripter */
} PEERS;

typedef struct {
	net_ulong prefix;	/* Prefix */
	char	  length;	/* Mask Length */
} prefix_t;

static char *fsm_state_names[] = {
	"", "Idle", "Connect", "Active", "OpenSent",
	"OpenConfirm", "Established"
};

/* Global Valiables */
extern char 	*bgptypestring[];
extern int	bgp_state;
extern int	bgp_event;
extern int	timeout_id;
extern PEERS	peer[];
extern fd_set	readfds;
extern char	syslogname[];
extern int	facility;
extern char	configfile[];
extern char	spooldir[];

#ifdef RTHISTORY
extern struct timeval	rthistcleartime;
#endif

/* bgpview.c */
extern void finish();
extern int check_id1topn(/* net_ulong id1 */);

#endif /* _BGP_H */
