#!/usr/bin/perl
# Flapped Route Summary for BGPView
# flapsum.pl,v 1.2 2001/04/04 06:13:52 kuniaki Exp

#
# Copyright (c) 2001 Internet Initiative Japan Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistribution with functional modification must include
#    prominent notice stating how and when and by whom it is
#    modified.
# 3. Redistributions in binary form have to be along with the source
#    code or documentation which include above copyright notice, this
#    list of conditions and the following disclaimer.
# 4. All commercial advertising materials mentioning features or use
#    of this software must display the following acknowledgement:
#      This product includes software developed by Internet
#      Initiative Japan Inc.
#
# THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.
#

{

	local($filename, $cnt, @eachplen, $updated, $total, $active,
	      $totalupdate, $totalwithdraw, $withdrawed, $adaynew);

	$filename = $ARGV[0];
	$cnt = 0;
	while($cnt <= 32) {
		$eachplen[$cnt] = 0;
		$cnt++;
	}

	$updated 	= 0;
	$total		= 0;
	$active		= 0;
	$totalupdate	= 0;
	$totalwithdraw	= 0;
	$withdrawed	= 0;
	$adaynew	= 0;
	$nflag		= 0;

	unless(open(FL, "$filename")) {
		print "Could not open log file : $filename\n";
		exit;
	}

	while(<FL>) {
		next if (/^$/);
		next if (/^\s+$/);
		next if (/AS_Path/);
		chomp;
		if (/==\ Prefix\ Update\ History\ ==/) {
			# Flapped Route
			$updated++;
			$eachplen[$lstack]++;
			$nflag = 0;
		} elsif (/WITHDRAW/) {
			$totalwithdraw++;
		} elsif (/UPDATE/) {
			$totalupdate++;
		} else {
			$total++;
			if ($nflag == 1) {
				$adaynew++;
				$nflag = 0;
			}
			if (/^\!/) {
				$withdrawed++;
			} else {
				$active++;
				if (/:/) {
					$nflag = 1;
				} else {
					$nflag = 0;
				}
			}
			@data = split(/\s+/, $_);
			@data2 = split(/\//, $data[1]);
			$pstack = $data2[0];
			$lstack = $data2[1];
		}
	}
	if ($nflag == 1) { $adaynew++; }

	close(FL);

	print "=== Summary ===\n";
	printf(" Total Route           : %7d routes\n",$total);
	printf(" Total Active Route    : %7d routes\n",$active);
	printf(" Total In-Active Route : %7d routes\n",$withdrawed);
	printf(" Stable Route          : %7d routes\n",$total-$updated);
	printf("          In new route : ");
	if ($adaynew >= ($total-$updated)) {
		printf("      0 routes\n");
		printf("  (Uncount: Too many new routes, probably reconnect)\n");
	} else {
		printf("%7d routes\n", $adaynew);
	}
	printf(" Total Updated Route   : %7d routes\n",$updated);
	printf(" Updated Still Active  : %7d routes\n", $updated-$withdrawed);
	printf(" Total Update Times    : %7d times\n",$totalupdate);
	printf(" Total Withdraw Times  : %7d times\n",$totalwithdraw);
	printf(" Total Changes         : %7d times\n",
						 $totalupdate+$totalwithdraw);
	printf("               Average : %7.1f times/updated route\n",
					($totalupdate+$totalwithdraw)/$updated);
	print "\n";
	print " Updated routes for each prefix length\n";
	$cnt=1;
	while($cnt<=16) {
		printf("   /%2d : %5d routes  |  /%2d : %5d routes\n", 
				$cnt, $eachplen[$cnt],
				$cnt+16, $eachplen[$cnt+16]);
		$cnt++;
	}
	print "\n";
}


