#!/bin/sh
#
# Cron File Reflesh
#

#
# Copyright (c) 2001 Internet Initiative Japan Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistribution with functional modification must include
#    prominent notice stating how and when and by whom it is
#    modified.
# 3. Redistributions in binary form have to be along with the source
#    code or documentation which include above copyright notice, this
#    list of conditions and the following disclaimer.
# 4. All commercial advertising materials mentioning features or use
#    of this software must display the following acknowledgement:
#      This product includes software developed by Internet
#      Initiative Japan Inc.
#
# THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.
#
# cronrefresh.sh,v 1.1 2001/04/04 06:04:37 kuniaki Exp
#

CRONFILE='/usr/local/etc/bgpview.cron'
NEWFNAME='route'`date '+%Y%m%d'`'.txt'
ROUTEDIR='/var/spool/bgpview/fullroute/'
CMDDO='do output route filename '$ROUTEDIR$NEWFNAME' detail'
FLAPSUM='/usr/local/bin/flapsum.pl'
FLAPSUMSHELL="/usr/local/bin/execflapsum.sh"
TEMPFILE='/usr/tmp/temp.txt'
SENDMAIL='/usr/sbin/sendmail'
SENDADDR='kuniaki@iij.ad.jp'


echo '0 0 * * * '$CMDDO > $CRONFILE
echo '1 0 * * * clear route history' >> $CRONFILE
echo '30 0 * * * do read cron file' >> $CRONFILE

echo 'Subject: BGPView Route History Summary' > $TEMPFILE
echo 'To: '$SENDADDR >> $TEMPFILE
echo 'From: BGPView <kuniaki@iij.ad.jp>' >> $TEMPFILE
echo '' >> $TEMPFILE

echo '#!/bin/sh' > $FLAPSUMSHELL
echo $FLAPSUM $ROUTEDIR$NEWFNAME ' >> ' $TEMPFILE >> $FLAPSUMSHELL
echo 'cat ' $TEMPFILE '|' $SENDMAIL $SENDADDR >> $FLAPSUMSHELL
chmod +x $FLAPSUMSHELL

